USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_PatientMovementsByDate]    Script Date: 07/31/2015 13:23:26 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Change History
-- Date		Author	Description
-- 6/23/15	AKR		Modified parameters for specialty transfers to use END_DATE parameter instread of returning all.
-- =============================================


ALTER PROCEDURE [dbo].[usp_Rpt_PatientMovementsByDate] 
	@USER_NAME NVARCHAR(100),
	@WARDGROUP_ID INT,
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@FACILITY_EXTENSION NVARCHAR(250),
	@TRANSACTION NVARCHAR(50),
	@TIME_ZONE_MINUTES_OFFSET INT
AS
BEGIN

	IF @START_DATE > @END_DATE
		RAISERROR ('The start date is greater than the end date. Please correct.', 18, 13)
	ELSE
	BEGIN
	
	-- create permission table
	CREATE TABLE #PERMISSION
        (
         DIM_ORGANIZATION_ID INT,
         DIM_WARD_ID INT
        )
    --insert permission for the user
    INSERT INTO #PERMISSION 
		SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
			CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON)
			CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON) ;
	
	
	
	DECLARE @FACILITY_ID INT, @VISTA_SITE_ID INT, @FACILITYTIMEZONE nvarchar(250)
	--get facility id
	SET @FACILITY_ID = dbo.ufn_GetFacilityIdByIdentifier(@FACILITY_EXTENSION);
	SELECT @VISTA_SITE_ID = DIM_ORGANIZATION_ID FROM DIM_ORGANIZATION WHERE ID = @FACILITY_ID
	
	Select @FACILITYTIMEZONE = TIMEZONE_NAME FROM DIM_FACILITY_TIME_ZONES WHERE FACILITY_ID = @FACILITY_EXTENSION
	
	DECLARE @RESULT TABLE
	( 
		IEN INT,
		RECORD_DATE VARCHAR(30),
		ENTERED_DATE VARCHAR(30),
		DIFF VARCHAR(10),
		WARD_NAME NVARCHAR(250),
		BED_NAME NVARCHAR(250),
		PATIENT_NAME NVARCHAR(250),
		TYPE_OF_TRANSACTION NVARCHAR(50),
		TYPE_OF_MOVEMENT NVARCHAR(250),
		DIFF_MINUTE INT
	) 
		
	--check if the user has permission for the facility		
	IF EXISTS(SELECT 1 
			  FROM #PERMISSION
			  WHERE DIM_ORGANIZATION_ID = @FACILITY_ID)
		BEGIN	
		
		--SET @START_DATE = DATEADD (minute , -@TIME_ZONE_MINUTES_OFFSET , @START_DATE );
		SET	@START_DATE = dbo.ufn_TimezoneConversion (@START_DATE, @FACILITYTIMEZONE,'UTC');
		--SET @END_DATE = DATEADD (minute , -@TIME_ZONE_MINUTES_OFFSET , @END_DATE );	
		SET	@END_DATE = dbo.ufn_TimezoneConversion (@END_DATE, @FACILITYTIMEZONE, 'UTC');	
				
		IF @TRANSACTION = 'Admissions'
			BEGIN
				INSERT INTO @RESULT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
				SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
				FROM ufn_GetPatientMovementAdmissionTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
			END
		ELSE
		IF @TRANSACTION = 'Discharges'
			BEGIN
				INSERT INTO @RESULT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
				SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
				FROM ufn_GetPatientMovementDischargeTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
			END
		ELSE
		IF @TRANSACTION = 'Specialty Transfers'
			BEGIN
				INSERT INTO @RESULT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
				SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
--				FROM ufn_GetPatientMovementSpecialtyTransfer_TIME_ZONE(@VISTA_SITE_ID, @START_DATE, NULL, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
				FROM ufn_GetPatientMovementSpecialtyTransfer_TIME_ZONE(@VISTA_SITE_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
			END
		ELSE
		IF @TRANSACTION = 'Inter Ward Transfers'
			BEGIN
				INSERT INTO @RESULT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
				SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
				FROM ufn_GetPatientMovementTransferTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
				WHERE PATIENT_MOVEMENT.TYPE_OF_TRANSACTION = 'TRANSFER'
			END
		ELSE
		IF @TRANSACTION = 'Intra Ward Transfers'
			BEGIN
				INSERT INTO @RESULT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
				SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
				FROM ufn_GetPatientIntraWardTransferTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT		
			END
		ELSE
	    IF @TRANSACTION = 'All'
			BEGIN
				INSERT INTO @RESULT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
					SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
					FROM ufn_GetPatientMovementAdmissionTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
					UNION
					SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
					FROM ufn_GetPatientMovementDischargeTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
					UNION
					SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
					FROM ufn_GetPatientMovementTransferTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT	
					UNION
					SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
					FROM ufn_GetPatientIntraWardTransferTransaction_TIME_ZONE(@FACILITY_ID, @WARDGROUP_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT		
					UNION
					SELECT PATIENT_MOVEMENT.IEN, PATIENT_MOVEMENT.RECORD_DATE, PATIENT_MOVEMENT.ENTERED_DATE, PATIENT_MOVEMENT.DIFF, PATIENT_MOVEMENT.WARD_NAME, PATIENT_MOVEMENT.BED_NAME, PATIENT_MOVEMENT.PATIENT_NAME, PATIENT_MOVEMENT.TYPE_OF_TRANSACTION, PATIENT_MOVEMENT.TYPE_OF_MOVEMENT, PATIENT_MOVEMENT.DIFF_MINUTE
--					FROM ufn_GetPatientMovementSpecialtyTransfer_TIME_ZONE(@VISTA_SITE_ID, @START_DATE, NULL, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT
					FROM ufn_GetPatientMovementSpecialtyTransfer_TIME_ZONE(@VISTA_SITE_ID, @START_DATE, @END_DATE, @FACILITYTIMEZONE) AS PATIENT_MOVEMENT	
			END
				
				
		SELECT * FROM  @RESULT
		END
	ELSE
		BEGIN

		SELECT *
				FROM @RESULT
		END
	DROP TABLE #PERMISSION
	
	END --error
END









GO


